/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.core.util;

import com.aptana.core.CorePlugin;
import com.aptana.core.logging.IdeLog;
import com.aptana.core.util.PlatformUtil;
import com.aptana.core.util.ProcessRunner;
import com.aptana.core.util.ProcessUtil;
import com.aptana.core.util.StringUtil;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileUtil {
    public static final String NEW_LINE = System.getProperty("line.separator");

    private FileUtil() {
    }

    public static IPath getTempDirectory() {
        return Path.fromOSString((String)System.getProperty("java.io.tmpdir"));
    }

    public static boolean isDirectoryAccessible(File directory) {
        if (directory == null || !directory.isDirectory()) {
            return false;
        }
        return directory.list() != null;
    }

    public static boolean isSymlink(File file) throws IOException {
        File canonical;
        Assert.isLegal((file != null ? 1 : 0) != 0);
        if (file.getParent() == null) {
            canonical = file;
        } else {
            File canonicalDir = file.getParentFile().getCanonicalFile();
            canonical = new File(canonicalDir, file.getName());
        }
        return !canonical.getCanonicalFile().equals(canonical.getAbsoluteFile());
    }

    public static boolean isZipFile(File file) {
        String filePath = file.getAbsolutePath();
        return filePath.toLowerCase().endsWith(".zip");
    }

    public static String compressPath(String path, int pathLength) {
        if (StringUtil.isEmpty(path)) {
            return path;
        }
        if ((path = path.replace('\\', '/')).length() > pathLength) {
            int firstSlash = path.indexOf(47, 1);
            int endSearch = path.length() - pathLength - firstSlash;
            if (firstSlash < 0 || endSearch < 0) {
                return path;
            }
            int lastSlash = path.indexOf(47, endSearch);
            if (lastSlash > firstSlash) {
                return String.valueOf(path.substring(0, firstSlash)) + "/..." + path.substring(lastSlash);
            }
            lastSlash = path.lastIndexOf(47, path.length() - 2);
            if (lastSlash > firstSlash) {
                return String.valueOf(path.substring(0, firstSlash)) + "/..." + path.substring(lastSlash);
            }
        }
        return path;
    }

    public static String compressLeadingPath(String path, int pathLength) {
        if (StringUtil.isEmpty(path)) {
            return path;
        }
        if ((path = path.replace('\\', '/')).length() <= pathLength) {
            return path;
        }
        int endSearch = path.length() - pathLength;
        int lastSlash = path.indexOf(47, endSearch);
        if (lastSlash < 0) {
            return path;
        }
        return "..." + path.substring(lastSlash);
    }

    public static String getExtension(String fileName) {
        if (StringUtil.isEmpty(fileName)) {
            return fileName;
        }
        int index = fileName.lastIndexOf(46);
        if (index == -1 || index == fileName.length()) {
            return "";
        }
        return fileName.substring(index + 1, fileName.length());
    }

    public static String getRandomFileName(String prefix, String suffix) {
        StringBuilder name = new StringBuilder();
        if (prefix != null) {
            name.append(prefix);
        }
        name.append((long)(2.147483647E9 * Math.random()));
        if (suffix != null) {
            name.append(suffix);
        }
        return name.toString();
    }

    public static boolean deleteRecursively(File dir) {
        if (dir == null) {
            return false;
        }
        boolean result = true;
        if (dir.isDirectory()) {
            IStatus status;
            if (!PlatformUtil.isWindows() && (status = new ProcessRunner().runInBackground("/bin/rm", "-rf", dir.getAbsolutePath())).isOK()) {
                return true;
            }
            File[] fileArray = dir.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File child = fileArray[n2];
                result = result && FileUtil.deleteRecursively(child);
                ++n2;
            }
        }
        return result && dir.delete();
    }

    public static List<File> gatherFilesFromCommandLineArguments(String[] arguments) {
        ArrayList<File> files = new ArrayList<File>();
        int i = 0;
        while (i < arguments.length) {
            if ("-keyring".equalsIgnoreCase(arguments[i])) {
                if (arguments.length > i + 1) {
                    ++i;
                }
            } else {
                File file = new File(arguments[i]);
                if (file.exists()) {
                    files.add(file);
                }
            }
            ++i;
        }
        return files;
    }

    public static int countFiles(File file) {
        block6: {
            if (file == null) {
                return 0;
            }
            if (!FileUtil.isSymlink(file)) break block6;
            return 1;
        }
        try {
            if (file.isDirectory()) {
                File[] children;
                int sum = 0;
                File[] fileArray = children = file.listFiles();
                int n = children.length;
                int n2 = 0;
                while (n2 < n) {
                    File child = fileArray[n2];
                    sum += FileUtil.countFiles(child);
                    ++n2;
                }
                return sum;
            }
        }
        catch (IOException e) {
            IdeLog.logError((Plugin)CorePlugin.getDefault(), e);
        }
        return 1;
    }

    public static boolean isValidDirectory(String path) {
        File file = new File(path);
        try {
            file.getCanonicalPath();
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    public static File findFile(File rootDir, final String fileExtension, boolean recursive) {
        File[] childFiles = rootDir.listFiles(new FileFilter(){

            public boolean accept(File file) {
                if (file.isDirectory()) {
                    return true;
                }
                String extension = FileUtil.getExtension(file.getName());
                return fileExtension.equals(extension);
            }
        });
        if (childFiles == null) {
            return null;
        }
        File[] fileArray = childFiles;
        int n = childFiles.length;
        int n2 = 0;
        while (n2 < n) {
            File childFile = fileArray[n2];
            String extension = FileUtil.getExtension(childFile.getName());
            if (fileExtension.equals(extension)) {
                return childFile;
            }
            File matchingFile = FileUtil.findFile(childFile, fileExtension, recursive);
            if (matchingFile != null) {
                return matchingFile;
            }
            ++n2;
        }
        return null;
    }

    public static IStatus chmod(String permString, File file) {
        char group = permString.charAt(1);
        char all = permString.charAt(2);
        if (all != group) {
            return new ProcessRunner().runInBackground("chmod", permString, file.getAbsolutePath());
        }
        boolean isReadable = (all >> 2 & 1) == 1;
        boolean isWritable = (all >> 1 & 1) == 1;
        boolean isExecutable = (all & '\u0001') == 1;
        file.setExecutable(isExecutable, false);
        file.setWritable(isWritable, false);
        file.setReadable(isReadable, false);
        char owner = permString.charAt(0);
        if (owner != all) {
            isReadable = (owner >> 2 & 1) == 1;
            isWritable = (owner >> 1 & 1) == 1;
            isExecutable = (owner & '\u0001') == 1;
            file.setExecutable(isExecutable, true);
            file.setWritable(isWritable, true);
            file.setReadable(isReadable, true);
        }
        return Status.OK_STATUS;
    }

    public static String getPermissions(IPath filepath) {
        if (PlatformUtil.isWindows()) {
            return null;
        }
        if (PlatformUtil.isMac()) {
            String result = ProcessUtil.outputForCommand("stat", null, "-f", "%p", filepath.toOSString());
            return result.substring(3);
        }
        String result = ProcessUtil.outputForCommand("stat", null, "-c", "%a", filepath.toOSString());
        return StringUtil.pad(result, 3, '0');
    }

    public static boolean isEmptyDir(File dir) {
        if (!dir.exists()) {
            return true;
        }
        if (!dir.isDirectory()) {
            return false;
        }
        return dir.listFiles().length == 0;
    }

    public static IStatus createSymlink(String symLinkName, IPath sourcePath, IPath targetPath) {
        if (PlatformUtil.isMac() || PlatformUtil.isLinux()) {
            return new ProcessRunner().runInBackground(sourcePath, "ln", "-s", targetPath.toOSString(), symLinkName);
        }
        if (PlatformUtil.isWindows()) {
            return new ProcessRunner().runInBackground(sourcePath, "mklink", "/D", symLinkName, targetPath.toOSString());
        }
        return Status.CANCEL_STATUS;
    }

    public static boolean canCreateSubdir(File parent) {
        if (parent == null) {
            return true;
        }
        if (parent.exists()) {
            return parent.isDirectory() && parent.canWrite();
        }
        return FileUtil.canCreateSubdir(parent.getParentFile());
    }

    public static File createTempFile(String prefix, String suffix) throws IOException {
        File f = File.createTempFile(prefix, suffix);
        f.deleteOnExit();
        return f;
    }
}

